__all__ = [ 'GetQMaxMainWindow' ]

"""
3ds Max Qt package
Contains helpers to retrieve Qt Widgets in the 3ds Max context
"""

from pymxs import runtime
from PySide2.QtWidgets import QWidget, QMainWindow
import shiboken2

def GetQMaxMainWindow():
    """
    Helper function to get 3ds Max's QMainWindow object
    """
    main_window_qwdgt = QWidget.find(runtime.windows.getMAXHWND())
    if main_window_qwdgt:
        return shiboken2.wrapInstance(shiboken2.getCppPointer(main_window_qwdgt)[0], QMainWindow)
    return None
